program process_nhdplus_connect
implicit none

!PURPOSE
!EDIT
!Add diagnosis that says how many nodes and how many nonzeros?
!Author: Cedric H. David, 2010 


!*******************************************************************************
!Declaration of variables
!*******************************************************************************
integer, parameter :: IS_reachtot=178551!137401!182240!68143!5175
integer :: JS_reachtot, JS_reachtot2

integer, dimension(IS_reachtot) :: IV_connect_id,IV_diverg
integer*8, dimension(IS_reachtot) :: IV_fromnode,IV_tonode
integer, dimension(IS_reachtot) :: IV_down,IV_nup,IV_up1,IV_up2,IV_up3,IV_up4

integer :: IS_diverg

character(len=100) :: nhdplus_connect_file='./nhdplus_connect_Reg07_TerminalPa=638200533.csv'
!Unit 10
character(len=100) :: rapid_connect_file='./rapid_connect_Reg07_TerminalPa=638200533.csv'
!Unit 20


!*******************************************************************************
!Read data files
!*******************************************************************************
open(10,file=nhdplus_connect_file,status='old')
do JS_reachtot=1,IS_reachtot
     !print *, JS_reachtot
     read(10,*) IV_connect_id(JS_reachtot), IV_fromnode(JS_reachtot),          &
                IV_tonode(JS_reachtot), IV_diverg(JS_reachtot)
     !print *, IV_connect_id(JS_reachtot)
enddo
close(10)


!*******************************************************************************
!Initialize to zero
!*******************************************************************************
do JS_reachtot=1,IS_reachtot
     IV_down(JS_reachtot)=0
     IV_nup(JS_reachtot)=0
     IV_up1(JS_reachtot)=0
     IV_up2(JS_reachtot)=0
     IV_up3(JS_reachtot)=0
     IV_up4(JS_reachtot)=0
end do

IS_diverg=0


!*******************************************************************************
!Create RAPID input file
!*******************************************************************************
do JS_reachtot=1,IS_reachtot
do JS_reachtot2=1,IS_reachtot

if (IV_tonode(JS_reachtot)==IV_fromnode(JS_reachtot2) .and.                    &
    IV_tonode(JS_reachtot)/=0 .and.                                            &
    IV_diverg(JS_reachtot2)/=2) then
     !Connectivity with downstream ID created only if downstream is not a minor  
     !divergence (IV_diverg=2) and if node ID is not 0
     IV_down(JS_reachtot)=IV_connect_id(JS_reachtot2)
end if

if (IV_fromnode(JS_reachtot)==IV_tonode(JS_reachtot2) .and.                    &
    IV_fromnode(JS_reachtot)/=0 .and.                                          &
    IV_diverg(JS_reachtot)/=2) then
     !Connectivity with upstream ID is created only if element is not a minor 
     !divergence itself (IV_diverg=2) and if node ID is not 0
     IV_nup(JS_reachtot)=IV_nup(JS_reachtot)+1
     if (IV_nup(JS_reachtot)==1) IV_up1(JS_reachtot)=IV_connect_id(JS_reachtot2)
     if (IV_nup(JS_reachtot)==2) IV_up2(JS_reachtot)=IV_connect_id(JS_reachtot2)
     if (IV_nup(JS_reachtot)==3) IV_up3(JS_reachtot)=IV_connect_id(JS_reachtot2)
     if (IV_nup(JS_reachtot)==4) IV_up4(JS_reachtot)=IV_connect_id(JS_reachtot2)
end if

end do
end do


!*******************************************************************************
!Print network statistics
!*******************************************************************************
print *, 'Number of  reaches in river network                 :', IS_reachtot
print *, 'Maximum number of upstream connections in network   :', maxval(IV_nup)
print *, 'Maximum number of upstream connections in data model:           4'
print *, 'Total number of nonzero elements in network matrix  :', sum(IV_nup)
do JS_reachtot=1,IS_reachtot
    if (IV_diverg(JS_reachtot)==2) IS_diverg=IS_diverg+1
end do
print *, 'Total number of divergences                         :', IS_diverg


!*******************************************************************************
!Write RAPID connectivity file from NHDPlus data
!*******************************************************************************
open(20,file=rapid_connect_file,status='new')
do JS_reachtot=1,IS_reachtot
     write(20,*) IV_connect_id(JS_reachtot), ',', IV_down(JS_reachtot), ',',   &
                 IV_nup(JS_reachtot), ',', IV_up1(JS_reachtot), ',',           &
                 IV_up2(JS_reachtot), ',', IV_up3(JS_reachtot), ',',           &
                 IV_up4(JS_reachtot)
enddo
close(20)


!*******************************************************************************
!End
!*******************************************************************************
print *, 'Done'


end program process_nhdplus_connect
