program process_hydrograph_rap
use netcdf
implicit none

!PURPOSE
!EDIT
!Add diagnosis that says how many nodes and how many nonzeros?
!Author: Cedric H. David, 2011 


!*******************************************************************************
!Declaration of variables
!*******************************************************************************
integer, parameter :: IS_reachtot=58140
integer :: JS_reachtot

integer, parameter :: IS_M=3652
integer :: JS_M,JS_R

integer, parameter :: IS_file=6
integer :: JS_file
integer, dimension(IS_file), parameter :: IV_reach_hydrograph_id=              &
          [26717,44835,46233,47161,50845,57805]    

integer :: IS_reachtot_index

real, dimension(IS_reachtot) :: ZV_read_reachtot
real :: ZS_Qout

integer, dimension(IS_reachtot) :: IV_basin_id

integer :: IS_nc_status
integer :: IS_nc_id_fil_Qout 
!netCDF file ids
integer, parameter :: IS_nc_ndim_rap=2 
!number of dimensions
integer, dimension(IS_nc_ndim_rap) :: IV_nc_start_rap,IV_nc_count_rap       
!for reading and writing netCDF files
integer :: IS_nc_id_var_Qout
!netCDF variable ids

character(len=100) :: basin_id_file='../../rapid_unified/input_Mississippi/basin_id_Mississippi_flowacc.csv'
!unit 10
character(len=100) :: rap_hydrograph_file
!unit 30

character(len=100) :: Qout_nc_file='../../rapid_unified/output/Qout_Mississippi_3652days_p0_dtR=1800s_n1_preonly.nc'


!*******************************************************************************
!Check that netCDF file actually existis
!*******************************************************************************
open(99,file=Qout_nc_file,status='old')
close(99)


!*******************************************************************************
!Reads basin_id_file, should be in same order as Qout_nc_file
!*******************************************************************************
open(10,file=basin_id_file, status='old')
read(10,*) IV_basin_id
close(10)


!*******************************************************************************
!Process all files
!*******************************************************************************
do JS_file=1,IS_file

!-------------------------------------------------------------------------------
!Create file name for hydrograph
!-------------------------------------------------------------------------------
write(rap_hydrograph_file,'(a20,i8,a8)') './hydrographs/daily_',               &
                                     IV_reach_hydrograph_id(JS_file), '_rap.csv'

!-------------------------------------------------------------------------------
!Determine index for IV_reach_hydrograph_id(JS_file)
!-------------------------------------------------------------------------------
do JS_reachtot=1,IS_reachtot
     if (IV_basin_id(JS_reachtot)==IV_reach_hydrograph_id(JS_file)) then
          IS_reachtot_index=JS_reachtot
     end if
end do
print *,'the index corresponding to reach ID ',IV_reach_hydrograph_id(JS_file),&
         'is:', IS_reachtot_index, 'within Qout_file' 


!-------------------------------------------------------------------------------
!create hydrograph file based on netCDF output file
!-------------------------------------------------------------------------------
IS_nc_status=NF90_OPEN(Qout_nc_file,NF90_NOWRITE,IS_nc_id_fil_Qout)
IS_nc_status=NF90_INQ_VARID(IS_nc_id_fil_Qout, 'Qout', IS_nc_id_var_Qout)

IV_nc_start_rap = (/1,1/)
IV_nc_count_rap = (/IS_reachtot,1/)

open(30,file=rap_hydrograph_file)

do JS_M=1,IS_M
     !print *, JS_M
     ZS_Qout=0
     do JS_R=1,8
          IS_nc_status=NF90_GET_VAR(IS_nc_id_fil_Qout,IS_nc_id_var_Qout,       &
                               ZV_read_reachtot,IV_nc_start_rap,IV_nc_count_rap) 
          IV_nc_start_rap(2) = IV_nc_start_rap(2) + 1 

          ZS_Qout=ZS_Qout+ZV_read_reachtot(IS_reachtot_index)
     end do
     ZS_Qout=ZS_Qout/8
     write(30,*) ZS_Qout
end do
IS_nc_status=NF90_CLOSE(IS_nc_id_fil_Qout)

close(30)

end do


!*******************************************************************************
!end
!*******************************************************************************

print *, 'Done'

end program process_hydrograph_rap
