#LANGUAGE
#Python
#PURPOSE
#Download data from USGS NWIS daily values using a CUAHSI WaterOneFlow 
#webservice based on its Web Service Description Language (WSDL).
#This script uses a Python package called ULMO.  This package can be obtained 
#from https://pypi.python.org or from https://github.com/twdb/ulmo. 
#Documentation on ULMO can be found at http://ulmo.readthedocs.org/en/latest
#AUTHOR
#Cedric H. David, 2013


#******************************************************************************
#Prerequisites
#******************************************************************************
import ulmo


#******************************************************************************
#Download data using ULMO
#******************************************************************************
site=ulmo.cuahsi.wof.get_site_info("http://river.sdsc.edu/wateroneflow/NWIS/DailyValues.asmx?WSDL", "NWISDV:08158000")

#ulmo.cuahsi.wof.get_values("http://river.sdsc.edu/wateroneflow/NWIS/DailyValues.asmx?WSDL","NWISDV:08158000","NWISDV:00060/DataType=Average")

data=ulmo.cuahsi.wof.get_values("http://river.sdsc.edu/wateroneflow/NWIS/DailyValues.asmx?WSDL","NWISDV:08158000","NWISDV:00060/DataType=Average", "01/01/2000", "12/31/2000")

for i in range(0,366):
    print data['values'][i]['datetime'], data['values'][i]['value']
